/* Copyright (C) 2004, 2006, 2009 and 2010 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef TRAY_ICON_H
#define TRAY_ICON_H

#include "prog_defs.h"

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include <c++-gtk-utils/emitter.h>
#include <c++-gtk-utils/gobj_handle.h>

class TrayIcon {

  GobjHandle<GtkStatusIcon> status_icon_h;
  GobjHandle<GtkWidget> menu_h;

  GtkMenuItem* list_received_faxes_item_p;
  GtkMenuItem* list_sent_faxes_item_p;
  GtkMenuItem* redial_queue_item_p;
  GtkMenuItem* receive_takeover_item_p;
  GtkMenuItem* receive_answer_item_p;
  GtkMenuItem* receive_standby_item_p;
  GtkMenuItem* stop_item_p;
  GtkMenuItem* quit_item_p;

  // not to be copied or assigned
  void operator=(const TrayIcon&);
  TrayIcon(const TrayIcon&);
public:
  enum MenuItem {quit, stop, receive_standby, receive_answer, receive_takeover,
		 list_received_faxes, list_sent_faxes, redial_queue};

  class CB;
  friend class CB;

  Emitter activated;
  EmitterArg<int> menu_item_chosen;
  EmitterArg<int&> get_state;
  EmitterArg<int&> get_new_fax_count;

  void set_tooltip_cb(const char* text);
  bool is_embedded(void);

  TrayIcon(void);
};

#endif
